package io.burkard.cdk.services.lightsail.cfnContainer

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ContainerProperty {

  def apply(
    containerName: Option[String] = None,
    image: Option[String] = None,
    ports: Option[List[_]] = None,
    command: Option[List[String]] = None,
    environment: Option[List[_]] = None
  ): software.amazon.awscdk.services.lightsail.CfnContainer.ContainerProperty =
    (new software.amazon.awscdk.services.lightsail.CfnContainer.ContainerProperty.Builder)
      .containerName(containerName.orNull)
      .image(image.orNull)
      .ports(ports.map(_.asJava).orNull)
      .command(command.map(_.asJava).orNull)
      .environment(environment.map(_.asJava).orNull)
      .build()
}
