package io.burkard.cdk.services.events.cfnRule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TargetProperty {

  def apply(
    arn: String,
    id: String,
    deadLetterConfig: Option[software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty] = None,
    ecsParameters: Option[software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty] = None,
    runCommandParameters: Option[software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty] = None,
    inputTransformer: Option[software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty] = None,
    httpParameters: Option[software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty] = None,
    batchParameters: Option[software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty] = None,
    redshiftDataParameters: Option[software.amazon.awscdk.services.events.CfnRule.RedshiftDataParametersProperty] = None,
    roleArn: Option[String] = None,
    sqsParameters: Option[software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty] = None,
    sageMakerPipelineParameters: Option[software.amazon.awscdk.services.events.CfnRule.SageMakerPipelineParametersProperty] = None,
    kinesisParameters: Option[software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty] = None,
    retryPolicy: Option[software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty] = None,
    inputPath: Option[String] = None,
    input: Option[String] = None
  ): software.amazon.awscdk.services.events.CfnRule.TargetProperty =
    (new software.amazon.awscdk.services.events.CfnRule.TargetProperty.Builder)
      .arn(arn)
      .id(id)
      .deadLetterConfig(deadLetterConfig.orNull)
      .ecsParameters(ecsParameters.orNull)
      .runCommandParameters(runCommandParameters.orNull)
      .inputTransformer(inputTransformer.orNull)
      .httpParameters(httpParameters.orNull)
      .batchParameters(batchParameters.orNull)
      .redshiftDataParameters(redshiftDataParameters.orNull)
      .roleArn(roleArn.orNull)
      .sqsParameters(sqsParameters.orNull)
      .sageMakerPipelineParameters(sageMakerPipelineParameters.orNull)
      .kinesisParameters(kinesisParameters.orNull)
      .retryPolicy(retryPolicy.orNull)
      .inputPath(inputPath.orNull)
      .input(input.orNull)
      .build()
}
