package io.burkard.cdk.services.events.cfnRule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BatchParametersProperty {

  def apply(
    jobDefinition: String,
    jobName: String,
    retryStrategy: Option[software.amazon.awscdk.services.events.CfnRule.BatchRetryStrategyProperty] = None,
    arrayProperties: Option[software.amazon.awscdk.services.events.CfnRule.BatchArrayPropertiesProperty] = None
  ): software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty =
    (new software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty.Builder)
      .jobDefinition(jobDefinition)
      .jobName(jobName)
      .retryStrategy(retryStrategy.orNull)
      .arrayProperties(arrayProperties.orNull)
      .build()
}
