package io.burkard.cdk.services.events.cfnConnection

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthParametersProperty {

  def apply(
    httpMethod: String,
    authorizationEndpoint: String,
    clientParameters: software.amazon.awscdk.services.events.CfnConnection.ClientParametersProperty,
    oAuthHttpParameters: Option[software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty] = None
  ): software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty =
    (new software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty.Builder)
      .httpMethod(httpMethod)
      .authorizationEndpoint(authorizationEndpoint)
      .clientParameters(clientParameters)
      .oAuthHttpParameters(oAuthHttpParameters.orNull)
      .build()
}
