package io.burkard.cdk.services.elasticloadbalancingv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NetworkLoadBalancerAttributes {

  def apply(
    loadBalancerArn: String,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    loadBalancerDnsName: Option[String] = None,
    loadBalancerCanonicalHostedZoneId: Option[String] = None
  ): software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes =
    (new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes.Builder)
      .loadBalancerArn(loadBalancerArn)
      .vpc(vpc.orNull)
      .loadBalancerDnsName(loadBalancerDnsName.orNull)
      .loadBalancerCanonicalHostedZoneId(loadBalancerCanonicalHostedZoneId.orNull)
      .build()
}
