package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoadBalancerTargetOptions {

  def apply(
    containerName: String,
    protocol: Option[software.amazon.awscdk.services.ecs.Protocol] = None,
    containerPort: Option[Number] = None
  ): software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions =
    (new software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions.Builder)
      .containerName(containerName)
      .protocol(protocol.orNull)
      .containerPort(containerPort.orNull)
      .build()
}
