package io.burkard.cdk.services.ecr

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPullThroughCacheRule {

  def apply(
    internalResourceId: String,
    ecrRepositoryPrefix: Option[String] = None,
    upstreamRegistryUrl: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ecr.CfnPullThroughCacheRule =
    software.amazon.awscdk.services.ecr.CfnPullThroughCacheRule.Builder
      .create(stackCtx, internalResourceId)
      .ecrRepositoryPrefix(ecrRepositoryPrefix.orNull)
      .upstreamRegistryUrl(upstreamRegistryUrl.orNull)
      .build()
}
