package io.burkard.cdk.services.dynamodb

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GlobalSecondaryIndexProps {

  def apply(
    sortKey: Option[software.amazon.awscdk.services.dynamodb.Attribute] = None,
    writeCapacity: Option[Number] = None,
    partitionKey: Option[software.amazon.awscdk.services.dynamodb.Attribute] = None,
    projectionType: Option[software.amazon.awscdk.services.dynamodb.ProjectionType] = None,
    readCapacity: Option[Number] = None,
    nonKeyAttributes: Option[List[String]] = None,
    indexName: Option[String] = None
  ): software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps =
    (new software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps.Builder)
      .sortKey(sortKey.orNull)
      .writeCapacity(writeCapacity.orNull)
      .partitionKey(partitionKey.orNull)
      .projectionType(projectionType.orNull)
      .readCapacity(readCapacity.orNull)
      .nonKeyAttributes(nonKeyAttributes.map(_.asJava).orNull)
      .indexName(indexName.orNull)
      .build()
}
