package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfigProps {

  def apply(
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None,
    deploymentConfigName: Option[String] = None,
    computePlatform: Option[String] = None,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None
  ): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps =
    (new software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps.Builder)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .computePlatform(computePlatform.orNull)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .build()
}
