package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EfsFileSystemLocationProps {

  def apply(
    location: String,
    mountPoint: String,
    identifier: String,
    mountOptions: Option[String] = None
  ): software.amazon.awscdk.services.codebuild.EfsFileSystemLocationProps =
    (new software.amazon.awscdk.services.codebuild.EfsFileSystemLocationProps.Builder)
      .location(location)
      .mountPoint(mountPoint)
      .identifier(identifier)
      .mountOptions(mountOptions.orNull)
      .build()
}
