package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSourceCredentialProps {

  def apply(
    token: String,
    serverType: String,
    authType: String,
    username: Option[String] = None
  ): software.amazon.awscdk.services.codebuild.CfnSourceCredentialProps =
    (new software.amazon.awscdk.services.codebuild.CfnSourceCredentialProps.Builder)
      .token(token)
      .serverType(serverType)
      .authType(authType)
      .username(username.orNull)
      .build()
}
