package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PublicKeyProps {

  def apply(
    encodedKey: String,
    comment: Option[String] = None,
    publicKeyName: Option[String] = None
  ): software.amazon.awscdk.services.cloudfront.PublicKeyProps =
    (new software.amazon.awscdk.services.cloudfront.PublicKeyProps.Builder)
      .encodedKey(encodedKey)
      .comment(comment.orNull)
      .publicKeyName(publicKeyName.orNull)
      .build()
}
