package io.burkard.cdk.services.appstream

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnImageBuilderProps {

  def apply(
    name: String,
    instanceType: String,
    displayName: Option[String] = None,
    accessEndpoints: Option[List[_]] = None,
    imageArn: Option[String] = None,
    domainJoinInfo: Option[software.amazon.awscdk.services.appstream.CfnImageBuilder.DomainJoinInfoProperty] = None,
    iamRoleArn: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    vpcConfig: Option[software.amazon.awscdk.services.appstream.CfnImageBuilder.VpcConfigProperty] = None,
    imageName: Option[String] = None,
    appstreamAgentVersion: Option[String] = None,
    enableDefaultInternetAccess: Option[Boolean] = None
  ): software.amazon.awscdk.services.appstream.CfnImageBuilderProps =
    (new software.amazon.awscdk.services.appstream.CfnImageBuilderProps.Builder)
      .name(name)
      .instanceType(instanceType)
      .displayName(displayName.orNull)
      .accessEndpoints(accessEndpoints.map(_.asJava).orNull)
      .imageArn(imageArn.orNull)
      .domainJoinInfo(domainJoinInfo.orNull)
      .iamRoleArn(iamRoleArn.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .vpcConfig(vpcConfig.orNull)
      .imageName(imageName.orNull)
      .appstreamAgentVersion(appstreamAgentVersion.orNull)
      .enableDefaultInternetAccess(enableDefaultInternetAccess.map(Boolean.box).orNull)
      .build()
}
