package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileCopyOptions {

  def apply(
    exclude: Option[List[String]] = None,
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None,
    followSymlinks: Option[software.amazon.awscdk.SymlinkFollowMode] = None
  ): software.amazon.awscdk.FileCopyOptions =
    (new software.amazon.awscdk.FileCopyOptions.Builder)
      .exclude(exclude.map(_.asJava).orNull)
      .ignoreMode(ignoreMode.orNull)
      .followSymlinks(followSymlinks.orNull)
      .build()
}
