package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHookTypeConfigProps {

  def apply(
    configuration: String,
    typeName: Option[String] = None,
    configurationAlias: Option[String] = None,
    typeArn: Option[String] = None
  ): software.amazon.awscdk.CfnHookTypeConfigProps =
    (new software.amazon.awscdk.CfnHookTypeConfigProps.Builder)
      .configuration(configuration)
      .typeName(typeName.orNull)
      .configurationAlias(configurationAlias.orNull)
      .typeArn(typeArn.orNull)
      .build()
}
