package io.burkard.cdk.services.sns

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SubscriptionOptions {

  def apply(
    endpoint: String,
    protocol: software.amazon.awscdk.services.sns.SubscriptionProtocol,
    subscriptionRoleArn: Option[String] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    rawMessageDelivery: Option[Boolean] = None,
    region: Option[String] = None,
    filterPolicy: Option[Map[String, _ <: software.amazon.awscdk.services.sns.SubscriptionFilter]] = None
  ): software.amazon.awscdk.services.sns.SubscriptionOptions =
    (new software.amazon.awscdk.services.sns.SubscriptionOptions.Builder)
      .endpoint(endpoint)
      .protocol(protocol)
      .subscriptionRoleArn(subscriptionRoleArn.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .rawMessageDelivery(rawMessageDelivery.map(Boolean.box).orNull)
      .region(region.orNull)
      .filterPolicy(filterPolicy.map(_.asJava).orNull)
      .build()
}
