package io.burkard.cdk.services.s3

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BlockPublicAccess {

  def apply(
    blockPublicAcls: Boolean,
    blockPublicPolicy: Boolean,
    ignorePublicAcls: Boolean,
    restrictPublicBuckets: Boolean
  ): software.amazon.awscdk.services.s3.BlockPublicAccess =
    software.amazon.awscdk.services.s3.BlockPublicAccess.Builder
      .create()
      .blockPublicAcls(blockPublicAcls)
      .blockPublicPolicy(blockPublicPolicy)
      .ignorePublicAcls(ignorePublicAcls)
      .restrictPublicBuckets(restrictPublicBuckets)
      .build()
}
