package io.burkard.cdk.services.route53resolver

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFirewallRuleGroupAssociationProps {

  def apply(
    priority: Number,
    vpcId: String,
    firewallRuleGroupId: String,
    name: Option[String] = None,
    mutationProtection: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroupAssociationProps =
    (new software.amazon.awscdk.services.route53resolver.CfnFirewallRuleGroupAssociationProps.Builder)
      .priority(priority)
      .vpcId(vpcId)
      .firewallRuleGroupId(firewallRuleGroupId)
      .name(name.orNull)
      .mutationProtection(mutationProtection.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
