package io.burkard.cdk.services.iot1click

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnProject {

  def apply(
    internalResourceId: String,
    placementTemplate: software.amazon.awscdk.services.iot1click.CfnProject.PlacementTemplateProperty,
    description: Option[String] = None,
    projectName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iot1click.CfnProject =
    software.amazon.awscdk.services.iot1click.CfnProject.Builder
      .create(stackCtx, internalResourceId)
      .placementTemplate(placementTemplate)
      .description(description.orNull)
      .projectName(projectName.orNull)
      .build()
}
