package io.burkard.cdk.services.iot

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTopicRuleDestination {

  def apply(
    internalResourceId: String,
    status: Option[String] = None,
    httpUrlProperties: Option[software.amazon.awscdk.services.iot.CfnTopicRuleDestination.HttpUrlDestinationSummaryProperty] = None,
    vpcProperties: Option[software.amazon.awscdk.services.iot.CfnTopicRuleDestination.VpcDestinationPropertiesProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iot.CfnTopicRuleDestination =
    software.amazon.awscdk.services.iot.CfnTopicRuleDestination.Builder
      .create(stackCtx, internalResourceId)
      .status(status.orNull)
      .httpUrlProperties(httpUrlProperties.orNull)
      .vpcProperties(vpcProperties.orNull)
      .build()
}
