package io.burkard.cdk.services.inspectorv2.cfnFilter

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FilterCriteriaProperty {

  def apply(
    ecrImageRegistry: Option[List[_]] = None,
    resourceId: Option[List[_]] = None,
    updatedAt: Option[List[_]] = None,
    ec2InstanceSubnetId: Option[List[_]] = None,
    lastObservedAt: Option[List[_]] = None,
    firstObservedAt: Option[List[_]] = None,
    awsAccountId: Option[List[_]] = None,
    inspectorScore: Option[List[_]] = None,
    portRange: Option[List[_]] = None,
    resourceType: Option[List[_]] = None,
    relatedVulnerabilities: Option[List[_]] = None,
    ecrImageRepositoryName: Option[List[_]] = None,
    ecrImageArchitecture: Option[List[_]] = None,
    findingArn: Option[List[_]] = None,
    componentId: Option[List[_]] = None,
    vulnerabilityId: Option[List[_]] = None,
    ec2InstanceVpcId: Option[List[_]] = None,
    resourceTags: Option[List[_]] = None,
    findingType: Option[List[_]] = None,
    vendorSeverity: Option[List[_]] = None,
    componentType: Option[List[_]] = None,
    ecrImageHash: Option[List[_]] = None,
    ecrImagePushedAt: Option[List[_]] = None,
    ec2InstanceImageId: Option[List[_]] = None,
    ecrImageTags: Option[List[_]] = None,
    findingStatus: Option[List[_]] = None,
    vulnerabilitySource: Option[List[_]] = None,
    severity: Option[List[_]] = None,
    title: Option[List[_]] = None,
    networkProtocol: Option[List[_]] = None,
    vulnerablePackages: Option[List[_]] = None
  ): software.amazon.awscdk.services.inspectorv2.CfnFilter.FilterCriteriaProperty =
    (new software.amazon.awscdk.services.inspectorv2.CfnFilter.FilterCriteriaProperty.Builder)
      .ecrImageRegistry(ecrImageRegistry.map(_.asJava).orNull)
      .resourceId(resourceId.map(_.asJava).orNull)
      .updatedAt(updatedAt.map(_.asJava).orNull)
      .ec2InstanceSubnetId(ec2InstanceSubnetId.map(_.asJava).orNull)
      .lastObservedAt(lastObservedAt.map(_.asJava).orNull)
      .firstObservedAt(firstObservedAt.map(_.asJava).orNull)
      .awsAccountId(awsAccountId.map(_.asJava).orNull)
      .inspectorScore(inspectorScore.map(_.asJava).orNull)
      .portRange(portRange.map(_.asJava).orNull)
      .resourceType(resourceType.map(_.asJava).orNull)
      .relatedVulnerabilities(relatedVulnerabilities.map(_.asJava).orNull)
      .ecrImageRepositoryName(ecrImageRepositoryName.map(_.asJava).orNull)
      .ecrImageArchitecture(ecrImageArchitecture.map(_.asJava).orNull)
      .findingArn(findingArn.map(_.asJava).orNull)
      .componentId(componentId.map(_.asJava).orNull)
      .vulnerabilityId(vulnerabilityId.map(_.asJava).orNull)
      .ec2InstanceVpcId(ec2InstanceVpcId.map(_.asJava).orNull)
      .resourceTags(resourceTags.map(_.asJava).orNull)
      .findingType(findingType.map(_.asJava).orNull)
      .vendorSeverity(vendorSeverity.map(_.asJava).orNull)
      .componentType(componentType.map(_.asJava).orNull)
      .ecrImageHash(ecrImageHash.map(_.asJava).orNull)
      .ecrImagePushedAt(ecrImagePushedAt.map(_.asJava).orNull)
      .ec2InstanceImageId(ec2InstanceImageId.map(_.asJava).orNull)
      .ecrImageTags(ecrImageTags.map(_.asJava).orNull)
      .findingStatus(findingStatus.map(_.asJava).orNull)
      .vulnerabilitySource(vulnerabilitySource.map(_.asJava).orNull)
      .severity(severity.map(_.asJava).orNull)
      .title(title.map(_.asJava).orNull)
      .networkProtocol(networkProtocol.map(_.asJava).orNull)
      .vulnerablePackages(vulnerablePackages.map(_.asJava).orNull)
      .build()
}
