package io.burkard.cdk.services.greengrass

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFunctionDefinitionVersionProps {

  def apply(
    functions: List[_],
    functionDefinitionId: String,
    defaultConfig: Option[software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.DefaultConfigProperty] = None
  ): software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersionProps =
    (new software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersionProps.Builder)
      .functions(functions.asJava)
      .functionDefinitionId(functionDefinitionId)
      .defaultConfig(defaultConfig.orNull)
      .build()
}
