package io.burkard.cdk.services.elasticache

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCacheClusterProps {

  def apply(
    numCacheNodes: Number,
    cacheNodeType: String,
    engine: String,
    snapshotArns: Option[List[String]] = None,
    cacheParameterGroupName: Option[String] = None,
    vpcSecurityGroupIds: Option[List[String]] = None,
    cacheSubnetGroupName: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    azMode: Option[String] = None,
    snapshotWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    notificationTopicArn: Option[String] = None,
    preferredAvailabilityZones: Option[List[String]] = None,
    port: Option[Number] = None,
    snapshotRetentionLimit: Option[Number] = None,
    logDeliveryConfigurations: Option[List[_]] = None,
    snapshotName: Option[String] = None,
    cacheSecurityGroupNames: Option[List[String]] = None,
    preferredAvailabilityZone: Option[String] = None,
    clusterName: Option[String] = None,
    engineVersion: Option[String] = None
  ): software.amazon.awscdk.services.elasticache.CfnCacheClusterProps =
    (new software.amazon.awscdk.services.elasticache.CfnCacheClusterProps.Builder)
      .numCacheNodes(numCacheNodes)
      .cacheNodeType(cacheNodeType)
      .engine(engine)
      .snapshotArns(snapshotArns.map(_.asJava).orNull)
      .cacheParameterGroupName(cacheParameterGroupName.orNull)
      .vpcSecurityGroupIds(vpcSecurityGroupIds.map(_.asJava).orNull)
      .cacheSubnetGroupName(cacheSubnetGroupName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .azMode(azMode.orNull)
      .snapshotWindow(snapshotWindow.orNull)
      .preferredMaintenanceWindow(preferredMaintenanceWindow.orNull)
      .autoMinorVersionUpgrade(autoMinorVersionUpgrade.map(Boolean.box).orNull)
      .notificationTopicArn(notificationTopicArn.orNull)
      .preferredAvailabilityZones(preferredAvailabilityZones.map(_.asJava).orNull)
      .port(port.orNull)
      .snapshotRetentionLimit(snapshotRetentionLimit.orNull)
      .logDeliveryConfigurations(logDeliveryConfigurations.map(_.asJava).orNull)
      .snapshotName(snapshotName.orNull)
      .cacheSecurityGroupNames(cacheSecurityGroupNames.map(_.asJava).orNull)
      .preferredAvailabilityZone(preferredAvailabilityZone.orNull)
      .clusterName(clusterName.orNull)
      .engineVersion(engineVersion.orNull)
      .build()
}
