package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNetworkInterfaceAttachmentProps {

  def apply(
    networkInterfaceId: String,
    instanceId: String,
    deviceIndex: String,
    deleteOnTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachmentProps =
    (new software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachmentProps.Builder)
      .networkInterfaceId(networkInterfaceId)
      .instanceId(instanceId)
      .deviceIndex(deviceIndex)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
