package io.burkard.cdk.services.codepipeline.actions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudFormationDeployStackInstancesAction {

  def apply(
    stackSetName: String,
    stackInstances: software.amazon.awscdk.services.codepipeline.actions.StackInstances,
    maxAccountConcurrencyPercentage: Option[Number] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    stackSetRegion: Option[String] = None,
    variablesNamespace: Option[String] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None,
    failureTolerancePercentage: Option[Number] = None,
    parameterOverrides: Option[software.amazon.awscdk.services.codepipeline.actions.StackSetParameters] = None
  ): software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesAction =
    software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesAction.Builder
      .create()
      .stackSetName(stackSetName)
      .stackInstances(stackInstances)
      .maxAccountConcurrencyPercentage(maxAccountConcurrencyPercentage.orNull)
      .role(role.orNull)
      .stackSetRegion(stackSetRegion.orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .failureTolerancePercentage(failureTolerancePercentage.orNull)
      .parameterOverrides(parameterOverrides.orNull)
      .build()
}
