package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AutoRollbackConfig {

  def apply(
    deploymentInAlarm: Option[Boolean] = None,
    failedDeployment: Option[Boolean] = None,
    stoppedDeployment: Option[Boolean] = None
  ): software.amazon.awscdk.services.codedeploy.AutoRollbackConfig =
    (new software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.Builder)
      .deploymentInAlarm(deploymentInAlarm.map(Boolean.box).orNull)
      .failedDeployment(failedDeployment.map(Boolean.box).orNull)
      .stoppedDeployment(stoppedDeployment.map(Boolean.box).orNull)
      .build()
}
