package io.burkard.cdk.services.backup

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BackupPlan {

  def apply(
    internalResourceId: String,
    backupVault: Option[software.amazon.awscdk.services.backup.IBackupVault] = None,
    backupPlanRules: Option[List[_ <: software.amazon.awscdk.services.backup.BackupPlanRule]] = None,
    backupPlanName: Option[String] = None,
    windowsVss: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.backup.BackupPlan =
    software.amazon.awscdk.services.backup.BackupPlan.Builder
      .create(stackCtx, internalResourceId)
      .backupVault(backupVault.orNull)
      .backupPlanRules(backupPlanRules.map(_.asJava).orNull)
      .backupPlanName(backupPlanName.orNull)
      .windowsVss(windowsVss.map(Boolean.box).orNull)
      .build()
}
