package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Route {

  def apply(
    internalResourceId: String,
    virtualRouter: software.amazon.awscdk.services.appmesh.IVirtualRouter,
    mesh: software.amazon.awscdk.services.appmesh.IMesh,
    routeName: Option[String] = None,
    routeSpec: Option[software.amazon.awscdk.services.appmesh.RouteSpec] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appmesh.Route =
    software.amazon.awscdk.services.appmesh.Route.Builder
      .create(stackCtx, internalResourceId)
      .virtualRouter(virtualRouter)
      .mesh(mesh)
      .routeName(routeName.orNull)
      .routeSpec(routeSpec.orNull)
      .build()
}
