package io.burkard.cdk.services.appflow.cfnFlow

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SourceFlowConfigProperty {

  def apply(
    connectorType: String,
    sourceConnectorProperties: software.amazon.awscdk.services.appflow.CfnFlow.SourceConnectorPropertiesProperty,
    connectorProfileName: Option[String] = None,
    incrementalPullConfig: Option[software.amazon.awscdk.services.appflow.CfnFlow.IncrementalPullConfigProperty] = None
  ): software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty =
    (new software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty.Builder)
      .connectorType(connectorType)
      .sourceConnectorProperties(sourceConnectorProperties)
      .connectorProfileName(connectorProfileName.orNull)
      .incrementalPullConfig(incrementalPullConfig.orNull)
      .build()
}
