package io.burkard.cdk.cloudassembly.schema

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AssetManifestProperties {

  def apply(
    file: String,
    bootstrapStackVersionSsmParameter: Option[String] = None,
    requiresBootstrapStackVersion: Option[Number] = None
  ): software.amazon.awscdk.cloudassembly.schema.AssetManifestProperties =
    (new software.amazon.awscdk.cloudassembly.schema.AssetManifestProperties.Builder)
      .file(file)
      .bootstrapStackVersionSsmParameter(bootstrapStackVersionSsmParameter.orNull)
      .requiresBootstrapStackVersion(requiresBootstrapStackVersion.orNull)
      .build()
}
