package io.burkard.cdk.services.stepfunctions.tasks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TransformInput {

  def apply(
    transformDataSource: software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource,
    compressionType: Option[software.amazon.awscdk.services.stepfunctions.tasks.CompressionType] = None,
    splitType: Option[software.amazon.awscdk.services.stepfunctions.tasks.SplitType] = None,
    contentType: Option[String] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.TransformInput =
    (new software.amazon.awscdk.services.stepfunctions.tasks.TransformInput.Builder)
      .transformDataSource(transformDataSource)
      .compressionType(compressionType.orNull)
      .splitType(splitType.orNull)
      .contentType(contentType.orNull)
      .build()
}
