package io.burkard.cdk.services.servicediscovery

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHttpNamespaceProps {

  def apply(
    name: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.servicediscovery.CfnHttpNamespaceProps =
    (new software.amazon.awscdk.services.servicediscovery.CfnHttpNamespaceProps.Builder)
      .name(name)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
