package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPipelineProps {

  def apply(
    pipelineName: String,
    pipelineDefinition: AnyRef,
    roleArn: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    pipelineDescription: Option[String] = None,
    parallelismConfiguration: Option[AnyRef] = None,
    pipelineDisplayName: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnPipelineProps =
    (new software.amazon.awscdk.services.sagemaker.CfnPipelineProps.Builder)
      .pipelineName(pipelineName)
      .pipelineDefinition(pipelineDefinition)
      .roleArn(roleArn)
      .tags(tags.map(_.asJava).orNull)
      .pipelineDescription(pipelineDescription.orNull)
      .parallelismConfiguration(parallelismConfiguration.orNull)
      .pipelineDisplayName(pipelineDisplayName.orNull)
      .build()
}
