package io.burkard.cdk.services.opensearchservice.cfnDomain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClusterConfigProperty {

  def apply(
    warmCount: Option[Number] = None,
    warmEnabled: Option[Boolean] = None,
    zoneAwarenessEnabled: Option[Boolean] = None,
    dedicatedMasterEnabled: Option[Boolean] = None,
    instanceType: Option[String] = None,
    warmType: Option[String] = None,
    dedicatedMasterCount: Option[Number] = None,
    dedicatedMasterType: Option[String] = None,
    instanceCount: Option[Number] = None,
    zoneAwarenessConfig: Option[software.amazon.awscdk.services.opensearchservice.CfnDomain.ZoneAwarenessConfigProperty] = None
  ): software.amazon.awscdk.services.opensearchservice.CfnDomain.ClusterConfigProperty =
    (new software.amazon.awscdk.services.opensearchservice.CfnDomain.ClusterConfigProperty.Builder)
      .warmCount(warmCount.orNull)
      .warmEnabled(warmEnabled.map(Boolean.box).orNull)
      .zoneAwarenessEnabled(zoneAwarenessEnabled.map(Boolean.box).orNull)
      .dedicatedMasterEnabled(dedicatedMasterEnabled.map(Boolean.box).orNull)
      .instanceType(instanceType.orNull)
      .warmType(warmType.orNull)
      .dedicatedMasterCount(dedicatedMasterCount.orNull)
      .dedicatedMasterType(dedicatedMasterType.orNull)
      .instanceCount(instanceCount.orNull)
      .zoneAwarenessConfig(zoneAwarenessConfig.orNull)
      .build()
}
