package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SlotTypeProperty {

  def apply(
    name: String,
    valueSelectionSetting: Option[software.amazon.awscdk.services.lex.CfnBot.SlotValueSelectionSettingProperty] = None,
    parentSlotTypeSignature: Option[String] = None,
    description: Option[String] = None,
    slotTypeValues: Option[List[_]] = None,
    externalSourceSetting: Option[software.amazon.awscdk.services.lex.CfnBot.ExternalSourceSettingProperty] = None
  ): software.amazon.awscdk.services.lex.CfnBot.SlotTypeProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.SlotTypeProperty.Builder)
      .name(name)
      .valueSelectionSetting(valueSelectionSetting.orNull)
      .parentSlotTypeSignature(parentSlotTypeSignature.orNull)
      .description(description.orNull)
      .slotTypeValues(slotTypeValues.map(_.asJava).orNull)
      .externalSourceSetting(externalSourceSetting.orNull)
      .build()
}
