package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LambdaFunction {

  def apply(
    handler: software.amazon.awscdk.services.lambda.IFunction,
    event: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    retryAttempts: Option[Number] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.events.targets.LambdaFunction =
    software.amazon.awscdk.services.events.targets.LambdaFunction.Builder
      .create(handler)
      .event(event.orNull)
      .retryAttempts(retryAttempts.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .maxEventAge(maxEventAge.orNull)
      .build()
}
