package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventBusAttributes {

  def apply(
    eventBusArn: String,
    eventBusName: String,
    eventBusPolicy: String,
    eventSourceName: Option[String] = None
  ): software.amazon.awscdk.services.events.EventBusAttributes =
    (new software.amazon.awscdk.services.events.EventBusAttributes.Builder)
      .eventBusArn(eventBusArn)
      .eventBusName(eventBusName)
      .eventBusPolicy(eventBusPolicy)
      .eventSourceName(eventSourceName.orNull)
      .build()
}
