package io.burkard.cdk.services.autoscaling

sealed abstract class TerminationPolicy(val underlying: software.amazon.awscdk.services.autoscaling.TerminationPolicy)
  extends Product
    with Serializable

object TerminationPolicy {
  implicit def toAws(value: TerminationPolicy): software.amazon.awscdk.services.autoscaling.TerminationPolicy =
    Option(value).map(_.underlying).orNull

  case object AllocationStrategy
    extends TerminationPolicy(software.amazon.awscdk.services.autoscaling.TerminationPolicy.ALLOCATION_STRATEGY)

  case object ClosestToNextInstanceHour
    extends TerminationPolicy(software.amazon.awscdk.services.autoscaling.TerminationPolicy.CLOSEST_TO_NEXT_INSTANCE_HOUR)

  case object Default
    extends TerminationPolicy(software.amazon.awscdk.services.autoscaling.TerminationPolicy.DEFAULT)

  case object NewestInstance
    extends TerminationPolicy(software.amazon.awscdk.services.autoscaling.TerminationPolicy.NEWEST_INSTANCE)

  case object OldestInstance
    extends TerminationPolicy(software.amazon.awscdk.services.autoscaling.TerminationPolicy.OLDEST_INSTANCE)

  case object OldestLaunchConfiguration
    extends TerminationPolicy(software.amazon.awscdk.services.autoscaling.TerminationPolicy.OLDEST_LAUNCH_CONFIGURATION)

  case object OldestLaunchTemplate
    extends TerminationPolicy(software.amazon.awscdk.services.autoscaling.TerminationPolicy.OLDEST_LAUNCH_TEMPLATE)
}
