package io.burkard.cdk.services.amplifyuibuilder

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnComponentProps {

  def apply(
    children: Option[List[_]] = None,
    name: Option[String] = None,
    collectionProperties: Option[Map[String, _]] = None,
    tags: Option[Map[String, String]] = None,
    overrides: Option[Map[String, _]] = None,
    componentType: Option[String] = None,
    properties: Option[Map[String, _]] = None,
    bindingProperties: Option[Map[String, _]] = None,
    sourceId: Option[String] = None,
    variants: Option[List[_]] = None
  ): software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps =
    (new software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps.Builder)
      .children(children.map(_.asJava).orNull)
      .name(name.orNull)
      .collectionProperties(collectionProperties.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .overrides(overrides.map(_.asJava).orNull)
      .componentType(componentType.orNull)
      .properties(properties.map(_.asJava).orNull)
      .bindingProperties(bindingProperties.map(_.asJava).orNull)
      .sourceId(sourceId.orNull)
      .variants(variants.map(_.asJava).orNull)
      .build()
}
