package io.burkard.cdk.services.rds

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DatabaseProxyAttributes {

  def apply(
    endpoint: String,
    securityGroups: List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup],
    dbProxyArn: String,
    dbProxyName: String
  ): software.amazon.awscdk.services.rds.DatabaseProxyAttributes =
    (new software.amazon.awscdk.services.rds.DatabaseProxyAttributes.Builder)
      .endpoint(endpoint)
      .securityGroups(securityGroups.asJava)
      .dbProxyArn(dbProxyArn)
      .dbProxyName(dbProxyName)
      .build()
}
