package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnADMChannelProps {

  def apply(
    clientSecret: String,
    clientId: String,
    applicationId: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnADMChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnADMChannelProps.Builder)
      .clientSecret(clientSecret)
      .clientId(clientId)
      .applicationId(applicationId)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
