package io.burkard.cdk.services.nimblestudio.cfnStudioComponent

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ActiveDirectoryConfigurationProperty {

  def apply(
    directoryId: Option[String] = None,
    organizationalUnitDistinguishedName: Option[String] = None,
    computerAttributes: Option[List[_]] = None
  ): software.amazon.awscdk.services.nimblestudio.CfnStudioComponent.ActiveDirectoryConfigurationProperty =
    (new software.amazon.awscdk.services.nimblestudio.CfnStudioComponent.ActiveDirectoryConfigurationProperty.Builder)
      .directoryId(directoryId.orNull)
      .organizationalUnitDistinguishedName(organizationalUnitDistinguishedName.orNull)
      .computerAttributes(computerAttributes.map(_.asJava).orNull)
      .build()
}
