package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBotProps {

  def apply(
    name: String,
    dataPrivacy: AnyRef,
    idleSessionTtlInSeconds: Number,
    roleArn: String,
    botTags: Option[List[_]] = None,
    autoBuildBotLocales: Option[Boolean] = None,
    botLocales: Option[List[_]] = None,
    description: Option[String] = None,
    testBotAliasTags: Option[List[_]] = None,
    botFileS3Location: Option[software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty] = None
  ): software.amazon.awscdk.services.lex.CfnBotProps =
    (new software.amazon.awscdk.services.lex.CfnBotProps.Builder)
      .name(name)
      .dataPrivacy(dataPrivacy)
      .idleSessionTtlInSeconds(idleSessionTtlInSeconds)
      .roleArn(roleArn)
      .botTags(botTags.map(_.asJava).orNull)
      .autoBuildBotLocales(autoBuildBotLocales.map(Boolean.box).orNull)
      .botLocales(botLocales.map(_.asJava).orNull)
      .description(description.orNull)
      .testBotAliasTags(testBotAliasTags.map(_.asJava).orNull)
      .botFileS3Location(botFileS3Location.orNull)
      .build()
}
