package io.burkard.cdk.services.iam

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AccessKeyProps {

  def apply(
    user: software.amazon.awscdk.services.iam.IUser,
    status: Option[software.amazon.awscdk.services.iam.AccessKeyStatus] = None,
    serial: Option[Number] = None
  ): software.amazon.awscdk.services.iam.AccessKeyProps =
    (new software.amazon.awscdk.services.iam.AccessKeyProps.Builder)
      .user(user)
      .status(status.orNull)
      .serial(serial.orNull)
      .build()
}
