package io.burkard.cdk.services.glue.cfnCrawler

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3TargetProperty {

  def apply(
    connectionName: Option[String] = None,
    path: Option[String] = None,
    exclusions: Option[List[String]] = None,
    sampleSize: Option[Number] = None,
    eventQueueArn: Option[String] = None,
    dlqEventQueueArn: Option[String] = None
  ): software.amazon.awscdk.services.glue.CfnCrawler.S3TargetProperty =
    (new software.amazon.awscdk.services.glue.CfnCrawler.S3TargetProperty.Builder)
      .connectionName(connectionName.orNull)
      .path(path.orNull)
      .exclusions(exclusions.map(_.asJava).orNull)
      .sampleSize(sampleSize.orNull)
      .eventQueueArn(eventQueueArn.orNull)
      .dlqEventQueueArn(dlqEventQueueArn.orNull)
      .build()
}
