package io.burkard.cdk.services.elasticbeanstalk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEnvironmentProps {

  def apply(
    applicationName: String,
    environmentName: Option[String] = None,
    platformArn: Option[String] = None,
    tier: Option[software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironment.TierProperty] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    operationsRole: Option[String] = None,
    templateName: Option[String] = None,
    solutionStackName: Option[String] = None,
    optionSettings: Option[List[_]] = None,
    versionLabel: Option[String] = None,
    cnamePrefix: Option[String] = None
  ): software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironmentProps =
    (new software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironmentProps.Builder)
      .applicationName(applicationName)
      .environmentName(environmentName.orNull)
      .platformArn(platformArn.orNull)
      .tier(tier.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .operationsRole(operationsRole.orNull)
      .templateName(templateName.orNull)
      .solutionStackName(solutionStackName.orNull)
      .optionSettings(optionSettings.map(_.asJava).orNull)
      .versionLabel(versionLabel.orNull)
      .cnamePrefix(cnamePrefix.orNull)
      .build()
}
