package io.burkard.cdk.services.eks

sealed abstract class ClusterLoggingTypes(val underlying: software.amazon.awscdk.services.eks.ClusterLoggingTypes)
  extends Product
    with Serializable

object ClusterLoggingTypes {
  implicit def toAws(value: ClusterLoggingTypes): software.amazon.awscdk.services.eks.ClusterLoggingTypes =
    Option(value).map(_.underlying).orNull

  case object Api
    extends ClusterLoggingTypes(software.amazon.awscdk.services.eks.ClusterLoggingTypes.API)

  case object Audit
    extends ClusterLoggingTypes(software.amazon.awscdk.services.eks.ClusterLoggingTypes.AUDIT)

  case object Authenticator
    extends ClusterLoggingTypes(software.amazon.awscdk.services.eks.ClusterLoggingTypes.AUTHENTICATOR)

  case object ControllerManager
    extends ClusterLoggingTypes(software.amazon.awscdk.services.eks.ClusterLoggingTypes.CONTROLLER_MANAGER)

  case object Scheduler
    extends ClusterLoggingTypes(software.amazon.awscdk.services.eks.ClusterLoggingTypes.SCHEDULER)
}
