package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Function {

  def apply(
    internalResourceId: String,
    code: software.amazon.awscdk.services.cloudfront.FunctionCode,
    comment: Option[String] = None,
    functionName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cloudfront.Function =
    software.amazon.awscdk.services.cloudfront.Function.Builder
      .create(stackCtx, internalResourceId)
      .code(code)
      .comment(comment.orNull)
      .functionName(functionName.orNull)
      .build()
}
