package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptions {

  def apply(
    encrypted: Option[Boolean] = None,
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.autoscaling.EbsDeviceVolumeType] = None,
    deleteOnTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.autoscaling.EbsDeviceOptions =
    (new software.amazon.awscdk.services.autoscaling.EbsDeviceOptions.Builder)
      .encrypted(encrypted.map(Boolean.box).orNull)
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
