package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CpuUtilizationScalingProps {

  def apply(
    targetUtilizationPercent: Number,
    cooldown: Option[software.amazon.awscdk.Duration] = None,
    disableScaleIn: Option[Boolean] = None,
    estimatedInstanceWarmup: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps =
    (new software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps.Builder)
      .targetUtilizationPercent(targetUtilizationPercent)
      .cooldown(cooldown.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).orNull)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .build()
}
